﻿--DROP PROCEDURE App.NVCC_usp_ProductionAccessLogUniqueUsers

CREATE PROCEDURE [App].[NVCC_usp_ProductionAccessLogUniqueUsers]
AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_ProductionAccessLogUniqueUsers
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 05-27-2016
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : Get unique users from the access log
--==================================================================================
--Uses: App.vNVCC_ProductionAccessLog
--Uses: App.NVCC_Users
--Uses: CDWWork.Patient.Patient
--Uses: CDWWork.SStaff.SStaff
BEGIN
	SELECT DISTINCT
		al.UserID,
		s.StaffName,
		p.Sta3n
	FROM
		App.vNVCC_ProductionAccessLog al
		INNER JOIN CDWWork.Patient.Patient p
			ON al.PatientSID = p.PatientSID
		LEFT JOIN App.NVCC_Users u
			ON al.UserID = u.DomainPlusNetworkUserName
		LEFT JOIN CDWWork.SStaff.SStaff s
			ON u.UserIEN = s.StaffIEN and u.Sta3n = s.Sta3n
	ORDER BY s.StaffName
END

